"use client"

import { ClientDataWrapper } from "@/components/client.data-wrapper";
import { LoadingDialog } from "@/components/loading.dialog";
import { AppCurrentUser } from "@/features/auth/types/session.amplify";
import { useGetAgencies } from "@/hooks/use-get-agencies";
import { useListAllUsers } from "../hooks/use-list-all-users";
import { WorkflowDialog } from "./workflow.dialog";

export function WorkflowDialogClient({
  currentUser,
}: {
  currentUser: AppCurrentUser
}) {
  const res = useListAllUsers();
  const { data: agencies } = useGetAgencies();

  if (!agencies) {
    return (
      <LoadingDialog />
    )
  }

  return (
    <ClientDataWrapper
      swr={res}
      overrides={{
        loading: (
          <LoadingDialog />
        ),
      }}
      content={(data) => (
        <WorkflowDialog data={data} agencies={agencies ?? []} currentUser={currentUser} />
      )}
    />
  )
}

